woodmartThemeModule.updateAjaxDeliveryDates = function () {
	var deliveryDates = document.querySelector('.wd-est-del');

	if (! deliveryDates) {
		return;
	}

	var productId     = deliveryDates.dataset.productId;
	var loaderOverlay = deliveryDates.querySelector('.wd-loader-overlay');
	
	loaderOverlay.classList.add('wd-loading');

	jQuery.ajax({
		url     : woodmart_settings.ajaxurl,
		data    : {
			action     : 'woodmart_update_delivery_dates',
			product_id : productId,
		},
		dataType: 'json',
		method  : 'GET',
		success : function(response) {
			if ( response.hasOwnProperty('fragments') ) {
				Object.keys(response.fragments).forEach(function(selector) {
					var value = response.fragments[selector];

					document.querySelectorAll(selector).forEach(function(node) {
						node.innerHtml = value;
					});
				});
			}
		},
		error   : function() {
			console.error('Something wrong with AJAX response. Probably some PHP conflict.');
		},
		complete: function() {
			loaderOverlay.classList.remove('wd-loading');
		}
	});
}

window.addEventListener('load', function() {
	woodmartThemeModule.updateAjaxDeliveryDates();
});
